# coding=utf-8
import arcpy
import sys
import os


def excute():
    paramCount = len(sys.argv)
    if paramCount != 6:
        print ("获取参数失败")
        return
    try:
        workspace = sys.argv[1]
        selectLayerName = sys.argv[2]
        outputPath = sys.argv[3]
        point_location = sys.argv[4]
        resultFeatureclass = sys.argv[5]
        arcpy.env.workspace = workspace
        selectLayer = arcpy.MakeFeatureLayer_management(selectLayerName, selectLayerName + "_Layer")
        selectalllayer = arcpy.SelectLayerByAttribute_management(selectLayer, "NEW_SELECTION")
        if point_location == "VERTEX":
            arcpy.FeatureVerticesToPoints_management(selectalllayer, outputPath + "\\P1",
                                                     point_location="DANGLE")
            arcpy.FeatureVerticesToPoints_management(selectalllayer, outputPath + "\\P2",
                                                     point_location="ALL")
            arcpy.FeatureVerticesToPoints_management(selectalllayer, outputPath + "\\P3",
                                                     point_location="BOTH_ENDS")
            arcpy.env.workspace = outputPath
            layer = arcpy.MakeFeatureLayer_management("P2", "P2_P")
            selectall = arcpy.SelectLayerByAttribute_management(layer, "NEW_SELECTION")
            relayer = arcpy.SelectLayerByLocation_management(selectall, "INTERSECT",
                                                             outputPath + "\\p3",
                                                             selection_type="REMOVE_FROM_SELECTION")
            layer1 = arcpy.MakeFeatureLayer_management("P3", "P3_P")
            selectall1 = arcpy.SelectLayerByAttribute_management(layer1, "NEW_SELECTION")
            relayer1 = arcpy.SelectLayerByLocation_management(selectall1, "INTERSECT",
                                                              outputPath + "\\p1",
                                                              selection_type="REMOVE_FROM_SELECTION")
            inFeatures = {relayer, relayer1}
            arcpy.Union_analysis(inFeatures, outputPath + "\\" + resultFeatureclass, "ALL")

            # fieldMaps = arcpy.FieldMappings()
            # fieldMap = arcpy.FieldMap()
            # fieldMap.addInputField(relayer, "ORIG_FID")
            # checkIdField = fieldMap.outputField
            # checkIdField.name = "ORIG_FID"
            # checkIdField.type = "Integer"
            # fieldMap.outputField = checkIdField
            # fieldMaps.addFieldMap(fieldMap)
            # arcpy.FeatureClassToFeatureClass_conversion(relayer, outputPath + "\\result.gdb",
            #                                             resultFeatureclass, field_mapping=fieldMaps)
        else:
            arcpy.FeatureVerticesToPoints_management(selectalllayer, outputPath + "\\" + resultFeatureclass,
                                                     point_location=point_location)
        print (outputPath)
    except Exception as e:
        print (e.message)


if __name__ == '__main__':
    excute()
